<?xml version="1.0" encoding="UTF-8"?>
<ICEFormat xmlns="http://www.isac-net.org/std/ICEFormat/1.0/ice"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xsi:schemaLocation="http://www.isac-net.org/std/ICEFormat/1.0/ice http://flowcyt.sf.net/ice/ICE.xsd"
	version="1.0">

	<ChannelDefinitions>
		<Channel Id="Chan1" Description="optional channel description goes here"> The channel node
			generally contains information about the excitation and emission parameters used to
			generate the images. See section 4.3 of the specification. </Channel>
		<Channel Id="Chan2" someAttribute="some Value">
			<Comment> This can contain any XML of your choosing. It is completely freeform.
			</Comment>
		</Channel>
		<Channel Id="Chan3">
			<Filter>650LP</Filter>
			<Laser>488nm</Laser>
			<Power>1 GW</Power>
		</Channel>
	</ChannelDefinitions>

	<SegmentationDefinitions>
		<Segmentation Id="Seg1" Description="Waterfall method">
			<Threshold>5px</Threshold>
		</Segmentation>
		<Segmentation Id="Seg2" Description="Some other algorithm"> Whatever stuff you want here.
			See section 4.4 of the standard </Segmentation>
	</SegmentationDefinitions>



	<FeatureDefinitions>
		<!-- These are common feature definitions that apply for all the wells -->
		<FeatureDefinition>
			<InfoFloat>
				<Description>DAPI cell area</Description>
				<ID>ch0-CellParameter-01</ID>
				<BitDepth>32</BitDepth>
			</InfoFloat>
		</FeatureDefinition>
		<FeatureDefinition>
			<InfoFloat>
				<Description>DAPI cell area thresholded</Description>
				<ID>ch0-CellParameter-02</ID>
				<BitDepth>32</BitDepth>
			</InfoFloat>
		</FeatureDefinition>
		<FeatureDefinition>
			<InfoFloat>
				<Description>DAPI cell intensity</Description>
				<ID>ch0-CellParameter-04</ID>
				<BitDepth>32</BitDepth>
			</InfoFloat>
		</FeatureDefinition>
		<FeatureDefinition>
			<InfoFloat>
				<Description>DAPI cell peak</Description>
				<ID>ch0-CellParameter-07</ID>
				<BitDepth>32</BitDepth>
			</InfoFloat>
		</FeatureDefinition>
		<FeatureDefinition>
			<InfoFloat>
				<Description>FL Green Alexa488 cell area</Description>
				<ID>ch1-CellParameter-01</ID>
				<BitDepth>32</BitDepth>
			</InfoFloat>
		</FeatureDefinition>
		<FeatureDefinition>
			<InfoFloat>
				<Description>FL Green Alexa488 cell area thresholded</Description>
				<ID>ch1-CellParameter-02</ID>
				<BitDepth>32</BitDepth>
			</InfoFloat>
		</FeatureDefinition>
		<FeatureDefinition>
			<InfoFloat>
				<Description>FL Green Alexa488 cell intensity</Description>
				<ID>ch1-CellParameter-04</ID>
				<BitDepth>32</BitDepth>
			</InfoFloat>
		</FeatureDefinition>
		<FeatureDefinition>
			<InfoFloat>
				<Description>FL Green Alexa488 cell peak</Description>
				<ID>ch1-CellParameter-07</ID>
				<BitDepth>32</BitDepth>
			</InfoFloat>
		</FeatureDefinition>
		<FeatureDefinition>
			<InfoFloat>
				<Description>FL Orange Alexa488 cell area</Description>
				<ID>ch2-CellParameter-01</ID>
				<BitDepth>32</BitDepth>
			</InfoFloat>
		</FeatureDefinition>
		<FeatureDefinition>
			<InfoFloat>
				<Description>FL Orange Alexa488 cell area thresholded</Description>
				<ID>ch2-CellParameter-02</ID>
				<BitDepth>32</BitDepth>
			</InfoFloat>
		</FeatureDefinition>
		<FeatureDefinition>
			<InfoFloat>
				<Description>FL Orange Alexa488 cell intensity</Description>
				<ID>ch2-CellParameter-04</ID>
				<BitDepth>32</BitDepth>
			</InfoFloat>
		</FeatureDefinition>
		<FeatureDefinition>
			<InfoFloat>
				<Description>FL Orange Alexa488 cell peak</Description>
				<ID>ch2-CellParameter-07</ID>
				<BitDepth>32</BitDepth>
			</InfoFloat>
		</FeatureDefinition>
		<FeatureDefinition>
			<InfoFloat>
				<Description>FL Red Alexa488 cell area</Description>
				<ID>ch3-CellParameter-01</ID>
				<BitDepth>32</BitDepth>
			</InfoFloat>
		</FeatureDefinition>
		<FeatureDefinition>
			<InfoFloat>
				<Description>FL Red Alexa488 cell area thresholded</Description>
				<ID>ch3-CellParameter-02</ID>
				<BitDepth>32</BitDepth>
			</InfoFloat>
		</FeatureDefinition>
		<FeatureDefinition>
			<InfoFloat>
				<Description>FL Red Alexa488 cell intensity</Description>
				<ID>ch3-CellParameter-04</ID>
				<BitDepth>32</BitDepth>
			</InfoFloat>
		</FeatureDefinition>
		<FeatureDefinition>
			<InfoFloat>
				<Description>FL Red Alexa488 cell peak</Description>
				<ID>ch3-CellParameter-07</ID>
				<BitDepth>32</BitDepth>
			</InfoFloat>
		</FeatureDefinition>
		<FeatureDefinition>
			<InfoCompositeImage>
				<Description>DNA stain</Description>
				<ID>ch0-CI</ID>
                <ChannelID>Chan1</ChannelID>				
				<ImageID>ch0-Picture</ImageID>
				<MaskID>ch0-Mask</MaskID>
			</InfoCompositeImage>
		</FeatureDefinition>
		<FeatureDefinition>
			<InfoCompositeImage>
				<Description>Green Fluorescence</Description>
				<ID>ch1-CI</ID>
                <ChannelID>Chan2</ChannelID>								
				<ImageID>ch1-Picture</ImageID>
				<MaskID>ch1-Mask</MaskID>
			</InfoCompositeImage>
		</FeatureDefinition>
		<FeatureDefinition>
			<InfoCompositeImage>
				<Description>Orange Fluorescence</Description>
				<ID>ch2-CI</ID>
                <ChannelID>Chan3</ChannelID>				
				<ImageID>ch2-Picture</ImageID>
				<MaskID>ch2-Mask</MaskID>
			</InfoCompositeImage>
		</FeatureDefinition>
		<FeatureDefinition>
			<InfoCompositeImage>
				<Description>Red Fluorescence</Description>
				<ID>ch3-CI</ID>
				<ImageID>ch3-Picture</ImageID>
				<MaskID>ch3-Mask</MaskID>
			</InfoCompositeImage>
		</FeatureDefinition>
	</FeatureDefinitions>

	<Plate Id="P1">

		<Layout>
			<Standard>96 well plate</Standard>
		</Layout>
		<Well>
			<!-- Well A01 -->
			<RowID>A</RowID>
			<ColumnID>01</ColumnID>
			<DataSet SiteRef="Site1">
				<MetaData>
					<NumberOfObjects>10787</NumberOfObjects>
					<Custom>
						<DataGeneratedBy>My Image Cytometer</DataGeneratedBy>
						<DataGeneratedDate>08/21/2011</DataGeneratedDate>
					</Custom>
				</MetaData>
				<CompositeImages>
					<Image>
						<ID>ch0-Picture</ID>
						<URL>file://Image1-ch0-Picture.png</URL>
						<Width>1392</Width>
						<Height>1040</Height>
					</Image>
					<Image>
						<ID>ch1-Picture</ID>
						<URL>file://Image1-ch1-Picture.png</URL>
						<Width>1392</Width>
						<Height>1040</Height>
					</Image>
					<Image>
						<ID>ch2-Picture</ID>
						<URL>file://Image1-ch2-Picture.png</URL>
						<Width>1392</Width>
						<Height>1040</Height>
					</Image>
					<Image>
						<ID>ch3-Picture</ID>
						<URL>file://Image1-ch3-Picture.png</URL>
						<Width>1392</Width>
						<Height>1040</Height>
					</Image>
				</CompositeImages>
				<Masks>
					<Mask>
						<ID>ch0-Mask</ID>
						<URL>file://Image1-ch0-Mask.mask</URL>
						<Width>1392</Width>
						<Height>1040</Height>
						<BitDepth>16</BitDepth>
						<SegmentationID>Seg1</SegmentationID>
					</Mask>
					<Mask>
						<ID>ch1-Mask</ID>
						<URL>file://Image1-ch1-Mask.mask</URL>
						<Width>1392</Width>
						<Height>1040</Height>
						<BitDepth>16</BitDepth>
						<SegmentationID>Seg2</SegmentationID>
					</Mask>
					<Mask>
						<ID>ch2-Mask</ID>
						<URL>file://Image1-ch2-Mask.mask</URL>
						<Width>1392</Width>
						<Height>1040</Height>
						<BitDepth>16</BitDepth>
					</Mask>
					<Mask>
						<ID>ch3-Mask</ID>
						<URL>file://Image1-ch3-Mask.mask</URL>
						<Width>1392</Width>
						<Height>1040</Height>
						<BitDepth>16</BitDepth>
					</Mask>
				</Masks>
				<FeatureValues>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch0-CellParameter-01</FeatureID>
							<URL>file://Image1-ch0-CellParameter-01.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch0-CellParameter-02</FeatureID>
							<URL>file://Image1-ch0-CellParameter-02.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch0-CellParameter-04</FeatureID>
							<URL>file://Image1-ch0-CellParameter-04.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch0-CellParameter-07</FeatureID>
							<URL>file://Image1-ch0-CellParameter-07.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch1-CellParameter-01</FeatureID>
							<URL>file://Image1-ch1-CellParameter-01.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch1-CellParameter-02</FeatureID>
							<URL>file://Image1-ch1-CellParameter-02.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch1-CellParameter-04</FeatureID>
							<URL>file://Image1-ch1-CellParameter-04.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch1-CellParameter-07</FeatureID>
							<URL>file://Image1-ch1-CellParameter-07.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch2-CellParameter-01</FeatureID>
							<URL>file://Image1-ch2-CellParameter-01.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch2-CellParameter-02</FeatureID>
							<URL>file://Image1-ch2-CellParameter-02.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch2-CellParameter-04</FeatureID>
							<URL>file://Image1-ch2-CellParameter-04.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch2-CellParameter-07</FeatureID>
							<URL>file://Image1-ch2-CellParameter-07.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch3-CellParameter-01</FeatureID>
							<URL>file://Image1-ch3-CellParameter-01.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch3-CellParameter-02</FeatureID>
							<URL>file://Image1-ch3-CellParameter-02.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch3-CellParameter-04</FeatureID>
							<URL>file://Image1-ch3-CellParameter-04.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch3-CellParameter-07</FeatureID>
							<URL>file://Image1-ch3-CellParameter-07.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<CompositeImage>
							<FeatureID>ch0-CI</FeatureID>
							<FeatureID>ch1-CI</FeatureID>
							<FeatureID>ch2-CI</FeatureID>
							<FeatureID>ch3-CI</FeatureID>
						</CompositeImage>
					</FeatureValue>
				</FeatureValues>
			</DataSet>
			<DataSet SiteRef="Site2">
				<MetaData>
					<NumberOfObjects>7541</NumberOfObjects>
					<Custom>
						<Custom>
							<DataGeneratedBy>My Image Cytometer</DataGeneratedBy>
							<DataGeneratedDate>08/21/2011</DataGeneratedDate>
						</Custom>
					</Custom>
				</MetaData>
				<CompositeImages>
					<Image>
						<ID>ch0-Picture</ID>
						<URL>file://Image2-ch0-Picture.png</URL>
						<Width>1392</Width>
						<Height>1040</Height>
					</Image>
					<Image>
						<ID>ch1-Picture</ID>
						<URL>file://Image2-ch1-Picture.png</URL>
						<Width>1392</Width>
						<Height>1040</Height>
					</Image>
					<Image>
						<ID>ch2-Picture</ID>
						<URL>file://Image2-ch2-Picture.png</URL>
						<Width>1392</Width>
						<Height>1040</Height>
					</Image>
					<Image>
						<ID>ch3-Picture</ID>
						<URL>file://Image2-ch3-Picture.png</URL>
						<Width>1392</Width>
						<Height>1040</Height>
					</Image>
				</CompositeImages>
				<Masks>
					<Mask>
						<ID>ch0-Mask</ID>
						<URL>file://Image2-ch0-Mask.mask</URL>
						<Width>1392</Width>
						<Height>1040</Height>
						<BitDepth>16</BitDepth>
					</Mask>
					<Mask>
						<ID>ch1-Mask</ID>
						<URL>file://Image2-ch1-Mask.mask</URL>
						<Width>1392</Width>
						<Height>1040</Height>
						<BitDepth>16</BitDepth>
					</Mask>
					<Mask>
						<ID>ch2-Mask</ID>
						<URL>file://Image2-ch2-Mask.mask</URL>
						<Width>1392</Width>
						<Height>1040</Height>
						<BitDepth>16</BitDepth>
					</Mask>
					<Mask>
						<ID>ch3-Mask</ID>
						<URL>file://Image2-ch3-Mask.mask</URL>
						<Width>1392</Width>
						<Height>1040</Height>
						<BitDepth>16</BitDepth>
					</Mask>
				</Masks>
				<FeatureValues>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch0-CellParameter-01</FeatureID>
							<URL>file://Image2-ch0-CellParameter-01.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch0-CellParameter-02</FeatureID>
							<URL>file://Image2-ch0-CellParameter-02.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch0-CellParameter-04</FeatureID>
							<URL>file://Image2-ch0-CellParameter-04.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch0-CellParameter-07</FeatureID>
							<URL>file://Image2-ch0-CellParameter-07.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch1-CellParameter-01</FeatureID>
							<URL>file://Image2-ch1-CellParameter-01.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch1-CellParameter-02</FeatureID>
							<URL>file://Image2-ch1-CellParameter-02.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch1-CellParameter-04</FeatureID>
							<URL>file://Image2-ch1-CellParameter-04.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch1-CellParameter-07</FeatureID>
							<URL>file://Image2-ch1-CellParameter-07.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch2-CellParameter-01</FeatureID>
							<URL>file://Image2-ch2-CellParameter-01.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch2-CellParameter-02</FeatureID>
							<URL>file://Image2-ch2-CellParameter-02.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch2-CellParameter-04</FeatureID>
							<URL>file://Image2-ch2-CellParameter-04.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch2-CellParameter-07</FeatureID>
							<URL>file://Image2-ch2-CellParameter-07.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch3-CellParameter-01</FeatureID>
							<URL>file://Image2-ch3-CellParameter-01.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch3-CellParameter-02</FeatureID>
							<URL>file://Image2-ch3-CellParameter-02.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch3-CellParameter-04</FeatureID>
							<URL>file://Image2-ch3-CellParameter-04.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch3-CellParameter-07</FeatureID>
							<URL>file://Image2-ch3-CellParameter-07.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<CompositeImage>
							<FeatureID>ch0-CI</FeatureID>
							<FeatureID>ch1-CI</FeatureID>
							<FeatureID>ch2-CI</FeatureID>
							<FeatureID>ch3-CI</FeatureID>
						</CompositeImage>
					</FeatureValue>
				</FeatureValues>
			</DataSet>
		</Well>

		<Well>
			<!-- Well A03 -->
			<RowID>A</RowID>
			<ColumnID>03</ColumnID>
			<DataSet SiteRef="Site1">
				<MetaData>
					<NumberOfObjects>4903</NumberOfObjects>
					<Custom>
						<Custom>
							<DataGeneratedBy>My Image Cytometer</DataGeneratedBy>
							<DataGeneratedDate>08/21/2011</DataGeneratedDate>
						</Custom>
					</Custom>
				</MetaData>
				<CompositeImages>
					<Image>
						<ID>ch0-Picture</ID>
						<URL>file://Image3-ch0-Picture.png</URL>
						<Width>1392</Width>
						<Height>1040</Height>
					</Image>
					<Image>
						<ID>ch1-Picture</ID>
						<URL>file://Image3-ch1-Picture.png</URL>
						<Width>1392</Width>
						<Height>1040</Height>
					</Image>
					<Image>
						<ID>ch2-Picture</ID>
						<URL>file://Image3-ch2-Picture.png</URL>
						<Width>1392</Width>
						<Height>1040</Height>
					</Image>
					<Image>
						<ID>ch3-Picture</ID>
						<URL>file://Image3-ch3-Picture.png</URL>
						<Width>1392</Width>
						<Height>1040</Height>
					</Image>
				</CompositeImages>
				<Masks>
					<Mask>
						<ID>ch0-Mask</ID>
						<URL>file://Image3-ch0-Mask.mask</URL>
						<Width>1392</Width>
						<Height>1040</Height>
						<BitDepth>16</BitDepth>
					</Mask>
					<Mask>
						<ID>ch1-Mask</ID>
						<URL>file://Image3-ch1-Mask.mask</URL>
						<Width>1392</Width>
						<Height>1040</Height>
						<BitDepth>16</BitDepth>
					</Mask>
					<Mask>
						<ID>ch2-Mask</ID>
						<URL>file://Image3-ch2-Mask.mask</URL>
						<Width>1392</Width>
						<Height>1040</Height>
						<BitDepth>16</BitDepth>
					</Mask>
					<Mask>
						<ID>ch3-Mask</ID>
						<URL>file://Image3-ch3-Mask.mask</URL>
						<Width>1392</Width>
						<Height>1040</Height>
						<BitDepth>16</BitDepth>
					</Mask>
				</Masks>
				<FeatureValues>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch0-CellParameter-01</FeatureID>
							<URL>file://Image3-ch0-CellParameter-01.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch0-CellParameter-02</FeatureID>
							<URL>file://Image3-ch0-CellParameter-02.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch0-CellParameter-04</FeatureID>
							<URL>file://Image3-ch0-CellParameter-04.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch0-CellParameter-07</FeatureID>
							<URL>file://Image3-ch0-CellParameter-07.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch1-CellParameter-01</FeatureID>
							<URL>file://Image3-ch1-CellParameter-01.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch1-CellParameter-02</FeatureID>
							<URL>file://Image3-ch1-CellParameter-02.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch1-CellParameter-04</FeatureID>
							<URL>file://Image3-ch1-CellParameter-04.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch1-CellParameter-07</FeatureID>
							<URL>file://Image3-ch1-CellParameter-07.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch2-CellParameter-01</FeatureID>
							<URL>file://Image3-ch2-CellParameter-01.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch2-CellParameter-02</FeatureID>
							<URL>file://Image3-ch2-CellParameter-02.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch2-CellParameter-04</FeatureID>
							<URL>file://Image3-ch2-CellParameter-04.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch2-CellParameter-07</FeatureID>
							<URL>file://Image3-ch2-CellParameter-07.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch3-CellParameter-01</FeatureID>
							<URL>file://Image3-ch3-CellParameter-01.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch3-CellParameter-02</FeatureID>
							<URL>file://Image3-ch3-CellParameter-02.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch3-CellParameter-04</FeatureID>
							<URL>file://Image3-ch3-CellParameter-04.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch3-CellParameter-07</FeatureID>
							<URL>file://Image3-ch3-CellParameter-07.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<CompositeImage>
							<FeatureID>ch0-CI</FeatureID>
							<FeatureID>ch1-CI</FeatureID>
							<FeatureID>ch2-CI</FeatureID>
							<FeatureID>ch3-CI</FeatureID>
						</CompositeImage>
					</FeatureValue>
				</FeatureValues>
			</DataSet>
			<DataSet SiteRef="Site2">
				<MetaData>
					<NumberOfObjects>2423</NumberOfObjects>
					<Custom>
						<Custom>
							<DataGeneratedBy>My Image Cytometer</DataGeneratedBy>
							<DataGeneratedDate>08/21/2011</DataGeneratedDate>
						</Custom>
					</Custom>
				</MetaData>
				<CompositeImages>
					<Image>
						<ID>ch0-Picture</ID>
						<URL>file://Image4-ch0-Picture.png</URL>
						<Width>1392</Width>
						<Height>1040</Height>
					</Image>
					<Image>
						<ID>ch1-Picture</ID>
						<URL>file://Image4-ch1-Picture.png</URL>
						<Width>1392</Width>
						<Height>1040</Height>
					</Image>
					<Image>
						<ID>ch2-Picture</ID>
						<URL>file://Image4-ch2-Picture.png</URL>
						<Width>1392</Width>
						<Height>1040</Height>
					</Image>
					<Image>
						<ID>ch3-Picture</ID>
						<URL>file://Image4-ch3-Picture.png</URL>
						<Width>1392</Width>
						<Height>1040</Height>
					</Image>
				</CompositeImages>
				<Masks>
					<Mask>
						<ID>ch0-Mask</ID>
						<URL>file://Image4-ch0-Mask.mask</URL>
						<Width>1392</Width>
						<Height>1040</Height>
						<BitDepth>16</BitDepth>
					</Mask>
					<Mask>
						<ID>ch1-Mask</ID>
						<URL>file://Image4-ch1-Mask.mask</URL>
						<Width>1392</Width>
						<Height>1040</Height>
						<BitDepth>16</BitDepth>
					</Mask>
					<Mask>
						<ID>ch2-Mask</ID>
						<URL>file://Image4-ch2-Mask.mask</URL>
						<Width>1392</Width>
						<Height>1040</Height>
						<BitDepth>16</BitDepth>
					</Mask>
					<Mask>
						<ID>ch3-Mask</ID>
						<URL>file://Image4-ch3-Mask.mask</URL>
						<Width>1392</Width>
						<Height>1040</Height>
						<BitDepth>16</BitDepth>
					</Mask>
				</Masks>
				<FeatureValues>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch0-CellParameter-01</FeatureID>
							<URL>file://Image4-ch0-CellParameter-01.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch0-CellParameter-02</FeatureID>
							<URL>file://Image4-ch0-CellParameter-02.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch0-CellParameter-04</FeatureID>
							<URL>file://Image4-ch0-CellParameter-04.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch0-CellParameter-07</FeatureID>
							<URL>file://Image4-ch0-CellParameter-07.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch1-CellParameter-01</FeatureID>
							<URL>file://Image4-ch1-CellParameter-01.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch1-CellParameter-02</FeatureID>
							<URL>file://Image4-ch1-CellParameter-02.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch1-CellParameter-04</FeatureID>
							<URL>file://Image4-ch1-CellParameter-04.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch1-CellParameter-07</FeatureID>
							<URL>file://Image4-ch1-CellParameter-07.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch2-CellParameter-01</FeatureID>
							<URL>file://Image4-ch2-CellParameter-01.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch2-CellParameter-02</FeatureID>
							<URL>file://Image4-ch2-CellParameter-02.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch2-CellParameter-04</FeatureID>
							<URL>file://Image4-ch2-CellParameter-04.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch2-CellParameter-07</FeatureID>
							<URL>file://Image4-ch2-CellParameter-07.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch3-CellParameter-01</FeatureID>
							<URL>file://Image4-ch3-CellParameter-01.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch3-CellParameter-02</FeatureID>
							<URL>file://Image4-ch3-CellParameter-02.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch3-CellParameter-04</FeatureID>
							<URL>file://Image4-ch3-CellParameter-04.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<Primitive>
							<FeatureID>ch3-CellParameter-07</FeatureID>
							<URL>file://Image4-ch3-CellParameter-07.celldata</URL>
						</Primitive>
					</FeatureValue>
					<FeatureValue>
						<CompositeImage>
							<FeatureID>ch0-CI</FeatureID>
							<FeatureID>ch1-CI</FeatureID>
							<FeatureID>ch2-CI</FeatureID>
							<FeatureID>ch3-CI</FeatureID>
						</CompositeImage>
					</FeatureValue>
				</FeatureValues>
			</DataSet>
		</Well>
	</Plate>
	<Sitemap>
	  <Grid>
		<Rows>1</Rows>
		<Columns>2</Columns>
		<Site ID="Site1" Row="1" Column="1" />
		<Site ID="Site2" Row="1" Column="2" />
	  </Grid>
	</Sitemap>
</ICEFormat>
